#include <bits/stdc++.h>

#define ld long double
#define ll long long

using namespace std;

const ld eps = 1e-10;

ld dist(ll x1, ll y1, ll x2, ll y2) {

    return sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
}

ld slope(ll x1, ll y1, ll x2, ll y2) {

    /*
        y1 = k * x1 + n
        y2 = k * x2 + n

        k = (y1 - y2) / (x1 - x2)
    */

    return (ld)(y1 - y2) / (ld)(x1 - x2);
}

bool good(int n, ll r, ll x1, ll y1, ll x2, ll y2, ll x3, ll y3) {

    if(x2 != x1 && x2 != x3) {
        swap(x1, x2);
        swap(y1, y2);
    } else if(x3 != x1 && x3 != x2) {
        swap(x1, x3);
        swap(y1, y3);
    }

    ld a = dist(x1, y1, x2, y2), b = dist(x1, y1, x3, y3), c = dist(x2, y2, x3, y3);
    ld FourArea = 2 * abs(x1 * y2 - x2 * y1 + x2 * y3 - x3 * y2 + x3 * y1 - x1 * y3);

    ld R = a * b * c / FourArea;
    if(abs(R - r) > eps)
        return false;
    // cout << "( " << x1 << ", " << y1 << " ), ( " << x2 << ", " << y2 << " ), ( " << x3 << ", " << y3 << " )" << endl;
    
    ld sx1 = (ld)(x1 + x2) / 2.0, sy1 = (ld)(y1 + y2) / 2.0;
    ld sx2 = (ld)(x1 + x3) / 2.0, sy2 = (ld)(y1 + y3) / 2.0;

    ld m1p = slope(x1, y1, x2, y2), m2p = slope(x1, y1, x3, y3);
    if(!m1p) {
        ld m2 = -1 / m2p;

        // Y - sy2 = m2(X - sx2)
        ld X = sx1;
        ld Y = m2 * (X - sx2) + sy2;

        return (abs(X - (ll)X) <= eps && abs(Y - (ll)Y) <= eps);
    } else if(!m2p) {
        ld m1 = -1 / m1p;

        // Y - sy1 = m1(X - sx1)
        ld X = sx2;
        ld Y = m1 * (X - sx1) + sy1;

        return (abs(X - (ll)X) <= eps && abs(Y - (ll)Y) <= eps);
    }

    ld m1 = -1 / m1p, m2 = -1 / m2p;

    /*
        Y - sy1 = m1(X - sx1)
        Y - sy2 = m2(X - sx2)

        sy1-sy2=m2(X-sx2)-m1(X-sx1)
        sy1-sy2+m2 * sx2- m1 * sx1=X(m2 - m1)
    */

   ld X = (sy1 - sy2 + m2 * sx2 - m1 * sx1) / (m2 - m1);
   ld Y = m1 * (X - sx1) + sy1;
   return (abs(X - (ll)X) <= eps && abs(Y - (ll)Y) <= eps);
}

int main() {

    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    int n;
    ll r;
    cin >> n >> r;

    ll x[n], y[n];
    for(int i = 0; i < n; i++)
        cin >> x[i] >> y[i];
    
    ll ans = 0;
    for(int i = 0; i < n - 2; i++)
        for(int j = i + 1; j < n - 1; j++)
            for(int k = j + 1; k < n; k++)
                if(good(n, r, x[i], y[i], x[j], y[j], x[k], y[k]))
                    ans++;
    cout << ans << endl;
    return 0;
}